#!/bin/bash

# Remove installed driver
DRIVER_PATH=$1
HAL_PLUGINS_DIR="/Library/Audio/Plug-Ins/HAL"
INSTALLED_DRIVER_PATH="${HAL_PLUGINS_DIR}/MMAudio Device.driver"

if [[ -d "${INSTALLED_DRIVER_PATH}" ]]; then
    rm -rf "${INSTALLED_DRIVER_PATH}" || exit 1
fi

# Install new driver

cp -R "${DRIVER_PATH}" "${HAL_PLUGINS_DIR}" || exit 1

# Restart coreaudiod to load the installed build

launchctl kill SIGTERM system/com.apple.audio.coreaudiod || killall coreaudiod

# Waiting for coreaudiod to restart
sleep 1

